﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_Klasyfikacja : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {

            }

            public int id { get; set; }
            public string text { get; set; }
            public string correct { get; set; }
            public string answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_Klasyfikacja(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Areas: MovingBox_AreasLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseIn != null)
            {
                switch (ContextParam.ExerciseIn.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Areas: MovingBox_AreasCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void MovingBox_AreasLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;

            XmlNode _xmlAreas = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Areas);

            if (_xmlAreas != null)
            {
                XmlNodeList _xmlListArea = _xmlAreas.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Area);

                foreach (XmlNode _loopXmlArea in _xmlListArea)
                {
                    string _AreaTitle = string.Empty;

                    XmlNode _text = _loopXmlArea.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text);
                    
                    if (_text != null)
                    {
                        _AreaTitle = Gemini.Utility.XML.Node.Get.CDATA(_text);
                    }

                    XmlNodeList _listXmlAreaBox = _loopXmlArea.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);
                    foreach (XmlNode _loopXmlBox in _listXmlAreaBox)
                    {
                        _stubIndex++;
                        ExerciseDataStub _loopStub = new ExerciseDataStub();
                        _loopStub.id = _stubIndex;
                        _loopStub.text = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlBox);
                        _loopStub.correct = _AreaTitle;

                        ExerciseData.Add(_loopStub);
                    }
                }
            }

            XmlNode _xmlExtraBox = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Extra_Box);
            XmlNodeList _listXmlExtraBox = _xmlExtraBox.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);

            foreach (XmlNode _loopXmlExtraBox in _listXmlExtraBox)
            {
                _stubIndex++;
                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.text = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlExtraBox);
                _loopStub.correct = string.Empty;

                ExerciseData.Add(_loopStub);
            }
        }

        private void MovingBox_AreasCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {


            XmlNode _xmlAreas = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Areas);

            if (_xmlAreas != null)
            {
                XmlNodeList _xmlListArea = _xmlAreas.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Area);

                Dictionary<int, string> _correctAnsverDictionary = new Dictionary<int, string>();

                int _boxIndex = 1;
                foreach (XmlNode _loopXmlArea in _xmlListArea)
                {
                    XmlNode _xmlAreaText = _loopXmlArea.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text);
                    string _areaText = Gemini.Utility.XML.Node.Get.CDATA(_xmlAreaText);

                    
                    XmlNodeList _listXmlAreaBox = _loopXmlArea.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);
                    foreach (XmlNode _loopXmlBox in _listXmlAreaBox)
                    {
                        _correctAnsverDictionary.Add(_boxIndex, _areaText);
                        _boxIndex++;
                    }
                }

                Exercise.TmpPoints = 0;
                int _stubIndex = 1;
                bool _isCorrect = false;

                foreach (GExerciseDataCheckOne _loopExerciseDataSave in ListExerciseDataSave)
                {
                    GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                    _loopExerciseCheck.id = _stubIndex;

                    _isCorrect = false;

                        if (_correctAnsverDictionary.ContainsKey(_stubIndex) && (_loopExerciseDataSave.answers[0] == _correctAnsverDictionary[_stubIndex]))
                        {
                            Exercise.TmpPoints++;
                            _isCorrect = true;
                        }

                    _loopExerciseCheck.success_arr.Add(_isCorrect);

                    ExerciseCheck.Add(_loopExerciseCheck);
                    _stubIndex++;
                }
            }
        }
    }
}
